<?php
header("Content-type: text/xml");
include('config_files/schools.php');
include('config_files/key.php');
if(isset($_GET['school'])  )
{
	if(!isset($_GET['auth']))
	{
		echo '<ResultDS>
				<Rslt>
				<response_code>001</response_code>
				<error>Authorization key missing</error>
				</Rslt>
				</ResultDS>';
		exit(-1);
	}
	else if($_GET['auth']!=$main_key)
	{
		echo '<ResultDS>
				<Rslt>
				<response_code>002</response_code>
				<error>Authorization error</error>
				</Rslt>
				</ResultDS>';
		exit(-1);
	}
	$error="";
	if(isset($_GET['withdrawn_on']))
		$withdrawn_on=$_GET['withdrawn_on'];
	if(isset($_GET['graduated_on']))
		$graduated_on=$_GET['graduated_on'];
	
	if(isset($withdrawn_on)&&isset($graduated_on))
		$error="Both withdrawn_on and graduated_on shouldn't be passed at once";
	if(!isset($withdrawn_on)&&!isset($graduated_on))
		$error="Any of withdrawn_on and graduated_on is required";

	if(isset($_GET['student_id']))
		$student_id=$_GET['student_id'];
	else
		$error="student_id is required";

	if(!empty($error))
	{
		echo '<ResultDS>
				<Rslt>
				<response_code>070</response_code>
				<error>'.$error.'</error>
				</Rslt>
				</ResultDS>';
		exit(-1);
	}

	$sc=$_GET['school'];
$ch = curl_init();

	if(isset($graduated_on))
		$final_data="{
		  	\"graduated_on\": \"$graduated_on\"
		}";
	else if(isset($withdrawn_on))
		$final_data="{
		  	\"withdrawn_on\": \"$withdrawn_on\"
		}";
	$link= '/v2/students/'.$student_id.'/archive';
	$url="https://api.managebac.com".$link;
	$result=get_result($url,$final_data,$schools[$sc]);
	$converted_result=json_decode($result,true);
	//print_r($converted_result);
	if( isset( $converted_result["status"] ) )
	{
		if( $converted_result["status"] == "ok" ){
			echo '<ResultDS>
				<Rslt>
				<response_code>200</response_code>
				<user_id>Archived Successfully</user_id>
				</Rslt>
				</ResultDS>';
			exit(0);
		}
	}
	
		echo '<ResultDS>
				<Rslt>
				<response_code>090</response_code>
				<error>Error archiving student: ';
				print_r($converted_result);
				echo '</error>
				</Rslt>
				</ResultDS>';
		exit(-1);


}


function get_result($url,$final_data,$auth_code)
{
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0');
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $final_data);
		curl_setopt($ch, CURLINFO_HEADER_OUT, true);

		$headers = array();
		$headers[] = "auth-token: ".$auth_code; //AUTH TOKEN INSERTION
		$headers[] = "Content-Type: application/json";
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}
		//curl_close ($ch);

		return $result;
}




?>